<?php

namespace NixfilePlugin\Admin;

use NixfilePlugin\Plugin;

class GalleryPage {

	public static function register() {
		add_menu_page(
			"Nixfile Gallery",
			"Nixfile Gallery",
			"manage_options",
			"nixfile-gallery",
			[ self::class, 'render' ],
			"dashicons-format-gallery",
		);
	}

	public static function enqueueAssets( $hook ): void {
		if ( $hook !== "toplevel_page_nixfile-gallery" ) {
			return;
		}
		wp_enqueue_style(
			"nixfile-gallery-style",
			plugin_dir_url( __FILE__ ) . "../../assets/css/nixfile-gallery.css",
		);
		wp_enqueue_script(
			"nixfile-gallery-script",
			plugin_dir_url( __FILE__ ) . "../../assets/js/nixfile-gallery.js",
			[ "jquery" ],
			"1.0",
			true
		);
		wp_localize_script(
			"nixfile-gallery-script",
			"NIXFILE_AJAX",
			[
				'ajax'  => admin_url( 'admin-ajax.php' ),
				'nonce' => wp_create_nonce( 'nixfile_gallery' ),
			]
		);
	}

	public static function render() {
		$options = get_option( Plugin::optionKey(), [
			'domain_id'              => '',
			'jalali_dates'           => 0,
			'modern_template'        => 0,
			'daily_backup'           => 0,
			'wp_toolbar_monitor'     => 0,
			'external_feature_image' => 0,
			'compress_on_upload'     => 1,
			'convert_to_avif'        => 1,
			'default_url'            => ''
		] );
		include __DIR__ . "/../../templates/gallery.php";
	}
}